using System;
using System.Windows.Forms;
using System.Threading;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.DAL.VAL;
using Action = System.Action;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Offers user a possibility to restore VistALink connection if it's down.
	/// Depending on user choice either restoring VistALink connection or simply exits.
	/// </summary>
	public class DlgRestoreVistALinkConnection : VbecsBaseForm
	{
		private Thread _connectionCheckerThread;
		private bool _checkIsRunning;
		private bool _restoreAttemptIsSuccessful;

		private Label lblVistALinkStatusHeader;		
		private Label lblPrimaryTextMessage;
		private TextBox txtShortStatusMessage;
		
		private VbecsButton btnCancel;
		private VbecsButton btnRestore;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgRestoreVistALinkConnection() : base( false )
		{			
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC103.DlgRestoreVistALinkConnection());
			
			RequiredFieldsLabel = false;

			_restoreAttemptIsSuccessful = false;
			_checkIsRunning = false;
			_connectionCheckerThread = null;

			UpdateStatusMessages( 
				StrRes.OtherMsg.UC103.VistALinkDetailedStatusNotConnected(), 
				StrRes.OtherMsg.UC103.VistALinkShortStatusNotConnected() );

			UpdateButtonsTooltips( 
				StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnRestoreDefault(), 
				StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnCancelDefault());

			btnCancel.Text = StrRes.OtherMsg.UC103.RestoreVistALinkConnectionButtonCancelText().ResString;
			btnRestore.Text = StrRes.OtherMsg.UC103.RestoreVistALinkConnectionButtonTest().ResString;

			this.AcceptButton = btnRestore;
			this.CancelButton = btnCancel;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblPrimaryTextMessage = new System.Windows.Forms.Label();
			this.btnCancel = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnRestore = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblVistALinkStatusHeader = new System.Windows.Forms.Label();
			this.txtShortStatusMessage = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(488, 30);
			this.vbecsLogo1.Title = "VistALink Connection";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 189);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// lblPrimaryTextMessage
			// 
			this.lblPrimaryTextMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblPrimaryTextMessage.Location = new System.Drawing.Point(8, 40);
			this.lblPrimaryTextMessage.Name = "lblPrimaryTextMessage";
			this.lblPrimaryTextMessage.Size = new System.Drawing.Size(472, 48);
			this.lblPrimaryTextMessage.TabIndex = 3;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(384, 176);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(96, 24);
			this.btnCancel.TabIndex = 6;
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnRestore
			// 
			this.btnRestore.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnRestore.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnRestore.Image = null;
			this.btnRestore.Location = new System.Drawing.Point(280, 176);
			this.btnRestore.Name = "btnRestore";
			this.btnRestore.Size = new System.Drawing.Size(96, 24);
			this.btnRestore.TabIndex = 7;
			this.btnRestore.Click += new System.EventHandler(this.btnRestore_Click);
			// 
			// lblVistALinkStatusHeader
			// 
			this.lblVistALinkStatusHeader.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblVistALinkStatusHeader.Location = new System.Drawing.Point(8, 120);
			this.lblVistALinkStatusHeader.Name = "lblVistALinkStatusHeader";
			this.lblVistALinkStatusHeader.Size = new System.Drawing.Size(472, 16);
			this.lblVistALinkStatusHeader.TabIndex = 8;
			this.lblVistALinkStatusHeader.Text = "VistALink Status";
			// 
			// txtShortStatusMessage
			// 
			this.txtShortStatusMessage.AccessibleDescription = "VistALink Status";
			this.txtShortStatusMessage.AccessibleName = "VistALink Status";
			this.txtShortStatusMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtShortStatusMessage.BackColor = System.Drawing.SystemColors.Info;
			this.txtShortStatusMessage.Location = new System.Drawing.Point(8, 144);
			this.txtShortStatusMessage.Name = "txtShortStatusMessage";
			this.txtShortStatusMessage.ReadOnly = true;
			this.txtShortStatusMessage.Size = new System.Drawing.Size(472, 20);
			this.txtShortStatusMessage.TabIndex = 9;
			this.txtShortStatusMessage.Text = "Unavailable";
			this.txtShortStatusMessage.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// DlgRestoreVistALinkConnection
			// 
			this.AcceptButton = this.btnRestore;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(488, 205);
			this.Controls.Add(this.txtShortStatusMessage);
			this.Controls.Add(this.lblVistALinkStatusHeader);
			this.Controls.Add(this.btnRestore);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.lblPrimaryTextMessage);
			this.hlphelpChm.SetHelpKeyword(this, "restore_VistA_connection.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(496, 232);
			this.Name = "DlgRestoreVistALinkConnection";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VistALink Connection";
			this.TopMost = true;
			this.Activated += new System.EventHandler(this.DlgRestoreVistALinkConnection_Activated);
			this.Controls.SetChildIndex(this.lblPrimaryTextMessage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnRestore, 0);
			this.Controls.SetChildIndex(this.lblVistALinkStatusHeader, 0);
			this.Controls.SetChildIndex(this.txtShortStatusMessage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// This method implements BR_103.02 and BR_103.04.
		/// </summary>
		private void RestoreConnection()
		{		
			lock( this )
				_checkIsRunning = true;
            _restoreAttemptIsSuccessful = VistALink.SilentCheckStatusReconnectIfNeeded(); 
			
			lock( this )
				_checkIsRunning = false;
            lock (this)
            {
                if (_restoreAttemptIsSuccessful)
                {
                    var findForm = FindForm();
                    if (findForm != null) Invoke(new MethodInvoker(delegate { findForm.Close(); }));
                    return;
                }
                else
                {
                    UpdateStatusMessages(
                        StrRes.OtherMsg.UC103.VistALinkDetailedStatusFailedToRestore(),
                        StrRes.OtherMsg.UC103.VistALinkShortStatusFailedToRestore());

                    UpdateButtonsTooltips(
                        StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnRestoreEndState(),
                        StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnCancelCloseFailure());
                }
            }
			

			btnCancel.Text = StrRes.OtherMsg.UC103.RestoreVistALinkConnectionButtonCloseText().ResString;

            //CR3414
		    if (InvokeRequired)
		    {
                BeginInvoke(new Action(Refresh));
		    }
            else
                Refresh();
		}

		private void btnRestore_Click(object sender, System.EventArgs e)
		{
			if( !btnRestore.EnabledButton )
				return;

			 btnRestore.EnabledButton = false;

			this.AcceptButton = this.CancelButton = btnCancel;

			UpdateStatusMessages( 
				StrRes.OtherMsg.UC103.VistALinkDetailedStatusConnecting(), 
				StrRes.OtherMsg.UC103.VistALinkShortStatusConnecting() );						

			UpdateButtonsTooltips( 
				StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnRestoreIsInProgress(), 
				StrRes.Tooltips.UC103.RestoreVistALinkConnectionbtnCancelCloseWhileRestoring());

			this.Refresh();

			// BR_103.03 is implemented here via starting a new thread.
			_connectionCheckerThread = new Thread( new ThreadStart( RestoreConnection ) );
			_connectionCheckerThread.Start();
 			
			this.Refresh();
		}

        //CR3414
		private void UpdateStatusMessages( StrRes.StringResourceItem longMessage, StrRes.StringResourceItem shortMessage )
		{
			lock( this )
			{
                if (txtShortStatusMessage.Parent.InvokeRequired)
                {

                    txtShortStatusMessage.Parent.BeginInvoke(
                        new Action(() =>
                        {
                            txtShortStatusMessage.Text = shortMessage.ResString;
                            lblPrimaryTextMessage.Text = longMessage.ResString; 
                        }));
                }
                else
                {
                    txtShortStatusMessage.Text = shortMessage.ResString; 
                    lblPrimaryTextMessage.Text = longMessage.ResString; 
                }
			}
		}

		private void UpdateButtonsTooltips( StrRes.StringResourceItem restoreButtonTooltip, StrRes.StringResourceItem cancelButtonTooltip )
		{
			lock( this )
			{
				SetThisToolTip( btnRestore, restoreButtonTooltip );
				SetThisToolTip( btnCancel, cancelButtonTooltip );
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			lock( this )
			{
				if( _connectionCheckerThread != null && _checkIsRunning )
					_connectionCheckerThread.Abort();
                var findForm = FindForm();
                if (findForm != null) Invoke(new MethodInvoker(delegate { findForm.Close(); }));
			}
		}

		private void DlgRestoreVistALinkConnection_Activated(object sender, System.EventArgs e)
		{
			if( btnRestore.EnabledButton )
				btnRestore.Focus();
			else
				btnCancel.Focus();
		}

		/// <summary>
		/// Indicates whether restore attempt is successful or not.
		/// </summary>
		public bool IsRestoreAttemptSuccessful
		{
			get
			{
				lock( this )
					return _restoreAttemptIsSuccessful;
			}
		}
	}
}
